/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.BlockFluidBase;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.wrapper.BlockFluidContainerWrapper;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.entity.EntityNPCInterface;

public class BlockWrapper
implements IBlock {
    public static volatile ConcurrentHashMap<Long, BlockWrapper> blockCache = new ConcurrentHashMap(25000);
    protected Block block;
    protected BlockPosWrapper bPos;
    protected BlockPos pos;
    public TileNpcEntity storage;
    private IData storeddata = new Data();
    private IData tempdata = new Data();
    public TileEntity tile;
    protected IWorld world;

    public static void clearCache() {
        blockCache.clear();
    }

    public static void checkClearCache() {
        if (blockCache.size() > 25000) {
            blockCache.keySet().stream().limit(blockCache.size() - 25000).forEach(blockCache::remove);
        }
    }

    public static IBlock createNew(World world, BlockPos pos, IBlockState state) {
        CustomNpcs.debugData.start(BlockWrapper.class);
        Long key = BlockWrapper.makeKey(world, state, pos);
        BlockWrapper wrapper = blockCache.get(key);
        if (wrapper == null) {
            wrapper = BlockWrapper.createBlockWrapper(world, state, pos);
            blockCache.put(key, wrapper);
        }
        CustomNpcs.debugData.end(BlockWrapper.class);
        return wrapper;
    }

    private static Long makeKey(World world, IBlockState state, BlockPos pos) {
        return pos.func_177986_g() << 32 | (long)(world == null ? 0 : world.field_73011_w.getDimension()) | (long)(state.func_177230_c().getRegistryName() == null ? 0 : state.func_177230_c().getRegistryName().hashCode());
    }

    private static BlockWrapper createBlockWrapper(World world, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        BlockWrapper wrapper = block instanceof BlockScripted ? new BlockScriptedWrapper(world, block, pos) : (block instanceof BlockScriptedDoor ? new BlockScriptedDoorWrapper(world, block, pos) : (block instanceof BlockFluidBase ? new BlockFluidContainerWrapper(world, block, pos) : new BlockWrapper(world, block, pos)));
        ((BlockWrapper)wrapper).setTile(world.func_175625_s(pos));
        return wrapper;
    }

    public BlockWrapper(World worldIn, Block blockIn, BlockPos posIn) {
        if (worldIn instanceof WorldServer) {
            this.world = Objects.requireNonNull(NpcAPI.Instance()).getIWorld(worldIn);
        } else if (worldIn != null) {
            WorldWrapper w = (WorldWrapper)WrapperNpcAPI.worldCache.get(worldIn.field_73011_w.getDimension());
            if (w != null) {
                if (w.world == null) {
                    w.world = worldIn;
                }
            } else {
                w = WorldWrapper.createNew(worldIn);
                WrapperNpcAPI.worldCache.put(worldIn.field_73011_w.getDimension(), w);
            }
            this.world = w;
        }
        this.block = blockIn;
        this.pos = posIn;
        this.bPos = new BlockPosWrapper(posIn);
        if (worldIn != null) {
            this.setTile(worldIn.func_175625_s(posIn));
        }
    }

    @Override
    public void blockEvent(int type, int data) {
        this.world.getMCWorld().func_175641_c(this.pos, this.block, type, data);
    }

    @Override
    public IContainer getContainer() {
        if (!this.isContainer()) {
            throw new CustomNPCsException("This block is not a container", new Object[0]);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIContainer((IInventory)this.tile);
    }

    @Override
    public String getDisplayName() {
        if (this.tile == null) {
            return this.getName();
        }
        return Objects.requireNonNull(this.tile.func_145748_c_()).func_150260_c();
    }

    @Override
    public Block getMCBlock() {
        return this.block;
    }

    @Override
    public IBlockState getMCBlockState() {
        return this.world.getMCWorld().func_180495_p(this.pos);
    }

    @Override
    public TileEntity getMCTileEntity() {
        return this.tile;
    }

    @Override
    public int getMetadata() {
        return this.block.func_176201_c(this.world.getMCWorld().func_180495_p(this.pos));
    }

    @Override
    public String getName() {
        return Block.field_149771_c.func_177774_c((Object)this.block) + "";
    }

    @Override
    public IPos getPos() {
        return this.bPos;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public INbt getTileEntityNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.tile.func_189515_b(compound);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(compound);
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public int getX() {
        return this.pos.func_177958_n();
    }

    @Override
    public int getY() {
        return this.pos.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.pos.func_177952_p();
    }

    @Override
    public boolean hasTileEntity() {
        return this.tile != null;
    }

    @Override
    public void interact(int side) {
        FakePlayer player = EntityNPCInterface.GenericPlayer;
        World w = this.world.getMCWorld();
        player.func_70029_a(w);
        player.func_70107_b((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        this.block.func_180639_a(w, this.pos, w.func_180495_p(this.pos), (EntityPlayer)EntityNPCInterface.CommandPlayer, EnumHand.MAIN_HAND, EnumFacing.values()[side], 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isAir() {
        return this.block.isAir(this.world.getMCWorld().func_180495_p(this.pos), (IBlockAccess)this.world.getMCWorld(), this.pos);
    }

    @Override
    public boolean isContainer() {
        return this.tile != null && this.tile instanceof IInventory && ((IInventory)this.tile).func_70302_i_() > 0;
    }

    @Override
    public boolean isRemoved() {
        return this.world.getMCWorld().func_180495_p(this.pos).func_177230_c() != this.block;
    }

    @Override
    public void remove() {
        this.world.getMCWorld().func_175698_g(this.pos);
    }

    @Override
    public BlockWrapper setBlock(IBlock block) {
        this.world.getMCWorld().func_175656_a(this.pos, block.getMCBlock().func_176223_P());
        return new BlockWrapper(this.world.getMCWorld(), block.getMCBlock(), this.pos);
    }

    @Override
    public BlockWrapper setBlock(String name) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
        this.world.getMCWorld().func_175656_a(this.pos, block.func_176223_P());
        return new BlockWrapper(this.world.getMCWorld(), block, this.pos);
    }

    @Override
    public void setMetadata(int i) {
        this.world.getMCWorld().func_180501_a(this.pos, this.block.func_176203_a(i), 3);
    }

    public void setTile(TileEntity tileIn) {
        this.tile = tileIn;
        if (this.tile instanceof TileNpcEntity) {
            this.storage = (TileNpcEntity)this.tile;
            this.tempdata = this.storage.tempData;
            this.storeddata = this.storage.storedData;
        }
    }

    @Override
    public void setTileEntityNBT(INbt nbt) {
        this.tile.func_145839_a(nbt.getMCNBT());
        this.tile.func_70296_d();
        IBlockState state = this.world.getMCWorld().func_180495_p(this.pos);
        this.world.getMCWorld().func_184138_a(this.pos, state, state, 3);
    }
}

